---
title: K3S GitLab Integration
series: Full Kubernetes Installation
description: Tutorial to configure deploys from GitLab to Kubernetes with GitLab Agent Integration
keywords: GitLab Agent Tutorial, K3S GitLab Integration, Kubernetes GitLab Integration, GitLab CI Kubernetes Deploy
publish: true
date: 2022-05-12
uuid: e95948b7-92ba-4691-9c46-286d4b5fb241
tags:
  - #kind/tutorial
  - #using/kubernetes
  - #using/gitlab
---

In this tutorial I will show how to configure integration of our K3S cluster with GitLab using GitLab Agent.

<!-- More -->

I will follow the [official guide](https://docs.gitlab.com/ee/user/clusters/agent/) [(Archived)](https://web.archive.org/web/20220420/https://docs.gitlab.com/ee/user/clusters/agent/) for CI/CD workflow and not the GitOps one which is more complicated.
First create a new GitLab repository under the group where you want to install the agent (you can adapt the repository created in the first tutorial in this series).
In this repository create a file called `config.yaml` at the path `.gitlab/agents/${AGENT_NAME}/config.yaml`. 
```yaml
# config.yaml
ci_access:
  groups:
    - id: ${GROUPNAME}
```
In this way we give access rights to our group to use the agent. Now push the repository.

Now install `helm` on your cluster if you haven't done it yet.
```bash
curl -fsSL ://raw.githubusercontent.com/helm/helm/master/scripts/get-helm-3 | bash
```

Now we need to register the agent with GitLab, so:
1. On the top bar, select **Menu > Projects** and find the project that has your agent configuration file.
2. From the left sidebar, select **Infrastructure > Kubernetes clusters**.
3. Select **Actions > Connect with Agent**.
4. From the **Select an agent** dropdown list, select the agent you want to register and select **Register an agent**.
5. GitLab generates a registration token for this agent. Store this token securely since you need it to install the agent in your cluster.
6. Copy the command under **Recommended installation method**. You need it when you use the one-liner installation method to install the agent in your cluster.

Now install the agent in the cluster using the provided helm commands and you should see it connected under the **Agent** menu.

Now in the GitLab CI/CD we can refer to the agent as a Kubernetes context, which allows us to run Kubernetes API commands as part of the CI/CD pipeline. To see further configuration of the CI/CD Workflow you can see the [official instruction page](https://docs.gitlab.com/ee/user/clusters/agent/ci_cd_tunnel.html) [(Archived)](https://web.archive.org/web/20220420/https://docs.gitlab.com/ee/user/clusters/agent/ci_cd_tunnel.html).
The authorized projects/groups now include a `KUBECONFIG` variable with context for every shared agent connection. We can choose the context to run `kubectl` commands from our CI/CD scripts.
You may want to follow [How to secure GitOps workflow on Kubernetes](https://about.gitlab.com/blog/2021/09/10/setting-up-the-k-agent/) [(Archived)](https://web.archive.org/web/20220420/https://about.gitlab.com/blog/2021/09/10/setting-up-the-k-agent/) to create many agents each of which grants access to various namespaces. The whole thing can be automated to segregate control of each repository to single namespaces.

An example of a deploy job in `.gitlab-ci.yaml` file is the following:
```yaml
deploy:
  image:
    name: bitnami/kubectl:latest
    entrypoint: [""]
  script:
  - kubectl config use-context ${GROUP_NAME}/${AGENT_PROJECT}:${AGENT_NAME}
  - kubectl get pods
```
